<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Web\AppointmentSchedulesResource;
use App\Models\AppointmentSchedule;
use App\Models\BookAppointment;
use App\Models\Currency;
use App\Models\Gateway;
use App\Models\Language;
use App\Models\ThemeSetting;
use Carbon\Carbon;

class APIController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth');
    }


    public function getAllSettings()
    {
        $settings = generalSettings();
        $default_currency = Currency::where('is_default', 1)->first();
        $settings['default_currency'] = $default_currency;
        $response = generateResponse($settings, true, "Settings Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getAllThemes()
    {
        $colors = ThemeSetting::active()->get();
        $response = generateResponse($colors, true, "Colors Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getCountries(Request $request)
    {
        $countries = APIGeneralController::getCountries($request);
        $response = generateResponse($countries, true, "Countries Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getStates(Request $request)
    {
        $request->validate(['country_id' => 'exists:countries,id']);
        $states = APIGeneralController::getStates($request);
        $response = generateResponse($states, true, "States Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getEvents(Request $request)
    {
        $events = APIGeneralController::searchEvents($request);
        $response = generateResponse($events, true, "Events Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getTestimonials(Request $request)
    {
        $testimonials = APIGeneralController::getTestimonials($request);
        $response = generateResponse($testimonials, true, "Testimonials Fetched Successfully", null, 'collection');
        return response()->json($response);
    }


    public function getPosts(Request $request)
    {
        $posts = APIGeneralController::searchPosts($request);
        $response = generateResponse($posts, true, "Posts Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getArchives(Request $request)
    {
        $archives = APIGeneralController::searchArchives($request);
        $response = generateResponse($archives, true, "Archives Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getBroadcasts(Request $request)
    {
        $broadcasts = APIGeneralController::searchBroadcasts($request);
        $response = generateResponse($broadcasts, true, "Broadcasts Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getPodcasts(Request $request)
    {
        $podcasts = APIGeneralController::searchPodcasts($request);
        $response = generateResponse($podcasts, true, "Podcasts Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getTherapists(Request $request)
    {
        // $request->validate(['country_id' => 'exists:countries,id']);
        $therapists = APIGeneralController::searchTherapists($request);
        $response = generateResponse($therapists, true, "Therapists Fetched Successfully", null, 'collection');
        return response()->json($response);
    }


    public function getTherapistReviews(Request $request, $user_name)
    {
        $therapist_reviews = APIGeneralController::searchTherapistReviews($request, $user_name);
        $response = generateResponse($therapist_reviews, true, "Therapist Reviews Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getTherapistPodcasts(Request $request, $user_name)
    {
        $therapist_podcasts = APIGeneralController::searchTherapistPodcasts($request, $user_name);
        $response = generateResponse($therapist_podcasts, true, "Therapist Podcasts Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getTherapistBroadcasts(Request $request, $user_name)
    {
        $therapist_broadcasts = APIGeneralController::searchTherapistBroadcasts($request, $user_name);
        $response = generateResponse($therapist_broadcasts, true, "Therapist Broadcasts Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getTherapistCommunityReviews(Request $request, $user_name)
    {
        $therapist_community_reviews = APIGeneralController::searchTherapistCommunityReviews($request, $user_name);
        $response = generateResponse($therapist_community_reviews, true, "TherapistCommunity Reviews Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getTherapistCommunitys(Request $request)
    {
        // $request->validate(['country_id' => 'exists:countries,id']);
        $therapist_communitys = APIGeneralController::searchTherapistCommunitys($request);
        $response = generateResponse($therapist_communitys, true, "TherapistCommunitys Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getTherapistCommunityCategories(Request $request)
    {
        $therapist_community_categories = APIGeneralController::getTherapistCommunityCategories($request);
        $response = generateResponse($therapist_community_categories, true, "TherapistCommunity Categories Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getBlogCategories(Request $request)
    {
        $blog_categories = APIGeneralController::getBlogCategories($request);
        $response = generateResponse($blog_categories, true, "Blog Categories Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getTags(Request $request)
    {
        $tags = APIGeneralController::getTags($request);
        $response = generateResponse($tags, true, "Tags Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getArchiveCategories(Request $request)
    {
        $archive_categories = APIGeneralController::getArchiveCategories($request);
        $response = generateResponse($archive_categories, true, "Blog Categories Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getServiceCategories(Request $request)
    {
        $service_categories = APIGeneralController::getServiceCategories($request);
        $response = generateResponse($service_categories, true, "Service Categories Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getServices(Request $request)
    {
        $services = APIGeneralController::searchServices($request);
        $response = generateResponse($services, true, "Services Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getTherapistCategories(Request $request)
    {
        $therapist_categories = APIGeneralController::getTherapistCategories($request);
        $response = generateResponse($therapist_categories, true, "Therapist All Categories Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getTherapistMainCategoriesWithChildrens(Request $request)
    {
        $therapist_main_categories = APIGeneralController::getTherapistMainCategoriesWithChildrens($request);
        $response = generateResponse($therapist_main_categories, true, "Therapist Main Categories with Childrens Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getCities(Request $request)
    {
        $request->validate(['state_id' => 'exists:states,id']);
        $cities = APIGeneralController::getCities($request);
        $response = generateResponse($cities, true, "Cities Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getFeaturedTags(Request $request)
    {
        $featured_tags = APIGeneralController::getFeaturedTags($request);
        $response = generateResponse($featured_tags, true, "Featured Tags Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getFeaturedTherapists(Request $request)
    {
        $featured_therapists = APIGeneralController::getFeaturedTherapists($request);
        $response = generateResponse($featured_therapists, true, "Featured Therapists Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getTopRatedTherapists(Request $request)
    {
        $featured_therapists = APIGeneralController::getTopRatedTherapists($request);
        $response = generateResponse($featured_therapists, true, "Top Therapists Fetched Successfully", null, 'collection');
        return response()->json($response);
    }

    public function getFeaturedEvents(Request $request)
    {
        $featured_events = APIGeneralController::getFeaturedEvents($request);
        $response = generateResponse($featured_events, true, "Featured Events Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getSpotlightTherapists(Request $request)
    {
        $spotlight_therapists = APIGeneralController::getSpotlightTherapists($request);
        $response = generateResponse($spotlight_therapists, true, "Spotlight Therapists Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getFeaturedTherapistCommunitys(Request $request)
    {
        $featured_therapist_communitys = APIGeneralController::getFeaturedTherapistCommunitys($request);
        $response = generateResponse($featured_therapist_communitys, true, "Featured TherapistCommunitys Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getCompanyPage(Request $request, $slug)
    {
        $company_page = APIGeneralController::getCompanyPage($request, $slug);
        $response = generateResponse($company_page, true, "Company Page $slug Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getAppointmentScheduleSlots(Request $request)
    {
        // $therapist_id = 2;
        $therapist_id = $request->therapist_id;
        $day = Carbon::parse($request->selected_date)->format('l');
        $day = strtolower($day);
        $date = Carbon::parse($request->selected_date);
        $schedule = AppointmentSchedule::with('schedule_slots')->where('therapist_id', $therapist_id)->where('appointment_type_id', $request->appointment_type_id)->where('day', $day)->first();
        if ($schedule) {
            $scheduleSlots = $schedule->schedule_slots;
            if (count($scheduleSlots) > 0) {
                foreach ($scheduleSlots as $scheduleSlot) {
                    $is_disabled = BookAppointment::where('therapist_id', $therapist_id)
                        ->whereDate('date', $date)
                        ->where('is_paid', 1)
                        ->where(function ($q) use ($scheduleSlot) {
                            $q->where(function ($z) use ($scheduleSlot) {
                                $z->where('start_time', $scheduleSlot->start_time);
                                $z->where('end_time', $scheduleSlot->end_time);
                            });
                        })->count();

                    $scheduleSlot['is_disabled'] = $is_disabled;
                }
            }
            $schedule = new AppointmentSchedulesResource($schedule);
        } else {
            $schedule = null;
        }
        $response = generateResponse($schedule, true, "Appointment Schedule Slots Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getTherapistCommunityAppointmentScheduleSlots(Request $request)
    {
        $therapist_community_id = $request->therapist_community_id;
        $day = Carbon::parse($request->selected_date)->format('l');
        $day = strtolower($day);
        $date = Carbon::parse($request->selected_date);

        $schedule = AppointmentSchedule::with('schedule_slots')->where('therapist_community_id', $therapist_community_id)->where('appointment_type_id', $request->appointment_type_id)->where('day', $day)->first();
        if ($schedule) {
            $scheduleSlots = $schedule->schedule_slots;
            if (count($scheduleSlots) > 0) {
                foreach ($scheduleSlots as $scheduleSlot) {
                    $is_disabled = BookAppointment::where('therapist_community_id', $therapist_community_id)
                        ->whereDate('date', $date)
                        ->where('is_paid', 1)
                        ->where(function ($q) use ($scheduleSlot) {
                            $q->where(function ($z) use ($scheduleSlot) {
                                $z->where('start_time', $scheduleSlot->start_time);
                                $z->where('end_time', $scheduleSlot->end_time);
                            });
                        })->count();

                    $scheduleSlot['is_disabled'] = $is_disabled;
                }
            }
            $schedule = new AppointmentSchedulesResource($schedule);
        } else {
            $schedule = null;
        }
        $response = generateResponse($schedule, true, "Appointment Schedule Slots Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getAppointmentTypes(Request $request)
    {
        $appointment_types = APIGeneralController::getAppointmentTypes($request);
        $response = generateResponse($appointment_types, true, "AppointmentTypes Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getAppCarousels(Request $request)
    {
        $appointment_types = APIGeneralController::getAppCarousels($request);
        $response = generateResponse($appointment_types, true, "App Carousel Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getAllGateways()
    {
        $gateways = Gateway::where('status', 1)->get();
        $response = generateResponse($gateways, true, "Gateways Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
    public function getAllLanguages()
    {
        $languages = Language::active()->get();
        $response = generateResponse($languages, true, "languages Fetched Successfully", null, 'collection');
        return response()->json($response);
    }
}
